IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CPJ_Turnos_Generar') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE CPJ_Turnos_Generar 
END
GO

CREATE PROCEDURE CPJ_Turnos_Generar		@pJson VARCHAR(8000)
AS 
SET NOCOUNT ON 

/*Variables recibidas por parmetro a traves del JSON*/
DECLARE @pFlagUsarTrans			TINYINT
DECLARE @pModoDebug				TINYINT
DECLARE @pId_Usuario			SMALLINT
DECLARE @pId_Sector				SMALLINT
DECLARE @pId_Recurso			INT
DECLARE @pFecha_Desde			DATETIME
DECLARE @pFecha_Hasta			DATETIME

SET @pFlagUsarTrans			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'FlagUsarTrans')), 0)
SET @pModoDebug				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pId_Usuario			= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Id_Usuario')), 0)
SET @pId_Sector				= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Id_Sector')), 0)
SET @pId_Recurso			= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Recurso')), 0)
SET @pFecha_Desde			= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha_Desde')), '19000101')
SET @pFecha_Hasta			= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha_Hasta')), '19000101')
/*FIN Variables recibidas por parmetro a traves del JSON*/

/*Variables Locales*/
DECLARE @cadaDiaAGenerar		DATETIME
DECLARE @Id_Recurso				INT
DECLARE @Id_Recurso_Horario		INT
DECLARE @Dia_De_La_Semana		VARCHAR(50)
DECLARE @Hora_Inicio			DATETIME
DECLARE @Hora_Fin				DATETIME
DECLARE @Frecuencia				INT
DECLARE @cadaMinutoAGenerar		DATETIME
DECLARE @fechaCompletaAGenerar	DATETIME
DECLARE @Flag_Id_Recurso_Bloq	INT
DECLARE @Cantidad_Turnos_Generados INT
DECLARE @Flag_Ya_Existe_Turno	TINYINT
/*FIN Variables Locales*/

BEGIN TRY
	IF @pFlagUsarTrans <> 0 
	BEGIN
		BEGIN TRAN
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Ingreso a Stored Procedure: CPJ_Turnos_Generar'
		PRINT 'Parmetros: '+ @pJson  
	END
	
	/*===================================================================*/	
	
	SET @Cantidad_Turnos_Generados = 0
	
	/*===================================================================*/	
	
	IF @pFecha_Desde = 0 RAISERROR ('Parameter "Fecha_Desde" mandatory', 16,  1)
	IF @pFecha_Hasta = 0 RAISERROR ('Parameter "Fecha_Hasta" mandatory', 16,  1)
	IF @pFecha_Desde >= @pFecha_Hasta  RAISERROR ('Parameter "Fecha_Hasta" greater than or equal Parameter "Fecha_Desde"', 16,  1)
	
	IF(@pId_Sector = 0 AND @pId_Recurso = 0)
	BEGIN
		IF @pId_Sector = 0 RAISERROR ('Parameter "Id_Sector" mandatory', 16,  1)
		IF @pId_Recurso = 0 RAISERROR ('Parameter "Id_Recurso" mandatory', 16,  1)
	END		
	
	--Primer dia a generar
	SET @cadaDiaAGenerar = @pFecha_Desde	
	
	WHILE(@cadaDiaAGenerar <= @pFecha_Hasta)
	BEGIN		
		SET @Dia_De_La_Semana = DATENAME(WEEKDAY, @cadaDiaAGenerar) --Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, Sunday
		IF(@pModoDebug = 1)
		BEGIN
			PRINT 'Dia: ' + @Dia_De_La_Semana + '(' + CONVERT(VARCHAR(10), @cadaDiaAGenerar, 102) + ')'
		END
		
		--POR SECTOR
		IF(@pId_Sector <> 0 AND @pId_Recurso = 0)
		BEGIN
			IF(@pModoDebug = 1)
			BEGIN
				PRINT 'Generacin POR SECTOR. pId_Sector: ' + CONVERT(VARCHAR(10), @pId_Sector)
			END
			--Recorro todos los recursos que tiene el sector		
			DECLARE curGenerarRecursosxDia CURSOR FOR
			SELECT Id_Recurso 
			FROM Empresas_Sedes_Sec_Recursos
			WHERE
			Activo = 1
			AND Id_Sector = @pId_Sector

			OPEN curGenerarRecursosxDia
			FETCH NEXT FROM curGenerarRecursosxDia INTO @Id_Recurso
			WHILE @@FETCH_STATUS = 0
			BEGIN
				IF(@pModoDebug = 1)
				BEGIN
					PRINT 'Id_Recurso: ' + CONVERT(VARCHAR(10), @Id_Recurso)
				END
				
				--Recorro todos los horarios que tiene el recurso
				DECLARE curGenerarRecursosxDiaxHorario CURSOR FOR
				SELECT Id_Recurso_Horario, Hora_Inicio, Hora_Fin, Frecuencia
				FROM Empresas_Sedes_Sec_Recuros_Horarios
				WHERE
				Activo = 1
				AND Id_Recurso = @Id_Recurso
				AND (	(ISNULL(Lunes, 0) = 1 AND @Dia_De_La_Semana = 'Monday') OR
						(ISNULL(Martes, 0) = 1 AND @Dia_De_La_Semana = 'Tuesday') OR
						(ISNULL(Miercoles, 0) = 1 AND @Dia_De_La_Semana = 'Wednesday') OR
						(ISNULL(Jueves, 0) = 1 AND @Dia_De_La_Semana = 'Thursday') OR
						(ISNULL(Viernes, 0) = 1 AND @Dia_De_La_Semana = 'Friday') OR
						(ISNULL(Sabado, 0) = 1 AND @Dia_De_La_Semana = 'Saturday') OR
						(ISNULL(Domingo, 0) = 1 AND @Dia_De_La_Semana = 'Sunday')
					)
				
				OPEN curGenerarRecursosxDiaxHorario
				FETCH NEXT FROM curGenerarRecursosxDiaxHorario INTO @Id_Recurso_Horario, @Hora_Inicio, @Hora_Fin, @Frecuencia
				WHILE @@FETCH_STATUS = 0
				BEGIN
					IF(@pModoDebug = 1)
					BEGIN
						PRINT 'Id_Recurso_Horario: ' + CONVERT(VARCHAR(10), @Id_Recurso_Horario) + ' Hora_Inicio: ' + CONVERT(VARCHAR(5), @Hora_Inicio, 8) + ' Hora_Fin: ' + CONVERT(VARCHAR(5), @Hora_Fin, 8) + ' Frecuencia: ' + CONVERT(VARCHAR(10), @Frecuencia)
					END
					
					--Hora inicio Ej: Ej. 1900-01-01T10:00:00
					--Hora fin Ej: Ej. 1900-01-01T10:50:00
					
					-- Primer Minuto a generar (Ej. 1900-01-01T10:00:00)				
					SET @cadaMinutoAGenerar = @Hora_Inicio
					
					WHILE (@cadaMinutoAGenerar <= @Hora_Fin)
					BEGIN
						IF(@pModoDebug = 1)
						BEGIN
							PRINT 'Hora: ' + CONVERT(VARCHAR(5), @cadaMinutoAGenerar, 8)
						END
						
						SET @Flag_Id_Recurso_Bloq = ISNULL((SELECT Id_Recurso_Bloq 
															FROM Empresas_Sedes_Sec_Recuros_Bloqueos 
															WHERE 
															Activo = 1
															AND Id_Recurso = @Id_Recurso 
															AND ((ISNULL(Lunes, 0) = 1 AND @Dia_De_La_Semana = 'Monday') OR
																(ISNULL(Martes, 0) = 1 AND @Dia_De_La_Semana = 'Tuesday') OR
																(ISNULL(Miercoles, 0) = 1 AND @Dia_De_La_Semana = 'Wednesday') OR
																(ISNULL(Jueves, 0) = 1 AND @Dia_De_La_Semana = 'Thursday') OR
																(ISNULL(Viernes, 0) = 1 AND @Dia_De_La_Semana = 'Friday') OR
																(ISNULL(Sabado, 0) = 1 AND @Dia_De_La_Semana = 'Saturday') OR
																(ISNULL(Domingo, 0) = 1 AND @Dia_De_La_Semana = 'Sunday')
																)
															AND Hora_Inicio <= @cadaMinutoAGenerar
															AND Hora_Fin >= @cadaMinutoAGenerar)
															, 0)
						
						IF(@Flag_Id_Recurso_Bloq > 0)
						BEGIN
							IF(@pModoDebug = 1)
							BEGIN
								PRINT 'El recurso se encuentra bloqueado para la hora: ' + CONVERT(VARCHAR(5), @cadaMinutoAGenerar, 8) + ' a traves del Id_Recurso_Bloq = ' + CONVERT(VARCHAR(10), @Flag_Id_Recurso_Bloq)
							END
						END
						ELSE
						BEGIN					
							SET @fechaCompletaAGenerar = CONVERT(DATETIME, 
																		CAST(DATEPART(yy, @cadaDiaAGenerar) AS CHAR(4)) + '-' + RIGHT('00' + CAST(DATEPART(mm, @cadaDiaAGenerar) AS VARCHAR), 2) + '-' + RIGHT('00' + CAST(DATEPART(dd, @cadaDiaAGenerar) AS VARCHAR), 2) 
																		+ 'T' + 
																		RIGHT('00' + CAST(DATEPART(HOUR, @cadaMinutoAGenerar) AS VARCHAR), 2) + ':' + RIGHT('00' + CAST(DATEPART(MINUTE, @cadaMinutoAGenerar) AS VARCHAR), 2) + ':' + '00'
																)
							
							IF(@pModoDebug = 1)
							BEGIN
								PRINT 'Fecha Completa a Generar: ' + CONVERT(VARCHAR(20), @fechaCompletaAGenerar, 120)
							END
								
							SET @Flag_Ya_Existe_Turno = (SELECT ISNULL((SELECT 1 FROM CRM_Turnos WHERE Id_Recurso = @Id_Recurso AND Fecha = @fechaCompletaAGenerar), 0))
							
							IF(@pModoDebug = 1)
							BEGIN
								PRINT '@Flag_Ya_Existe_Turno: ' + CONVERT(VARCHAR(10), @Flag_Ya_Existe_Turno)
							END
							
							IF(@Flag_Ya_Existe_Turno = 1)
							BEGIN
								IF(@pModoDebug = 1)
								BEGIN
									PRINT 'Ya existia un turno generado para el Id_Recurso: ' + CONVERT(VARCHAR(10), @Id_Recurso) + ' en la Fecha: ' + CONVERT(VARCHAR(20), @fechaCompletaAGenerar, 120)
								END
							END
							ELSE
							BEGIN					
								IF(@pModoDebug = 1)
								BEGIN
									PRINT 'Genera registro CRM_Turnos con los siguientes datos: Id_Usuario: ' + CONVERT(VARCHAR(10), @pId_Usuario) + '. Id_Recurso: ' + CONVERT(VARCHAR(10), @Id_Recurso) + ' Fecha: ' + CONVERT(VARCHAR(20), @fechaCompletaAGenerar, 120)
								END
								
								--Inserta el registro en CRM_Turnos
								SET @Cantidad_Turnos_Generados = @Cantidad_Turnos_Generados + 1
								INSERT INTO CRM_Turnos
								(Id_Usuario,			Id_Cliente,			Id_Recurso, 
								Fecha,					Descripcion,		Estado,
								Id_Trans,				Id_Recurso_Horario,	Frecuencia,
								Fecha_Generacion)
								VALUES
								(@pId_Usuario,			0,					@Id_Recurso,
								@fechaCompletaAGenerar,	'',					'',
								0,						@Id_Recurso_Horario,	@Frecuencia,
								GETDATE())
							END
						END
						
						--Siguiente minuto a generar
						SET @cadaMinutoAGenerar = DATEADD(MINUTE, @Frecuencia, @cadaMinutoAGenerar)
					END

					FETCH NEXT FROM curGenerarRecursosxDiaxHorario INTO @Id_Recurso_Horario, @Hora_Inicio, @Hora_Fin, @Frecuencia
				END
				CLOSE curGenerarRecursosxDiaxHorario
				DEALLOCATE curGenerarRecursosxDiaxHorario
				--FIN Recorro todos los horarios que tiene el recurso
				
				FETCH NEXT FROM curGenerarRecursosxDia INTO @Id_Recurso
			END
			CLOSE curGenerarRecursosxDia
			DEALLOCATE curGenerarRecursosxDia
			--FIN Recorro todos los recursos que tiene el sector
		END--IF(@pId_Sector <> 0)
		
		------------------------------------------------------------------------------------------------------------------
		
		--POR RECURSO
		IF(@pId_Recurso <> 0)
		BEGIN
			IF(@pModoDebug = 1)
			BEGIN
				PRINT 'Generacin POR RECURSO. pId_Recurso: ' + CONVERT(VARCHAR(10), @pId_Recurso)
			END
			
			--Recorro todos los horarios que tiene el recurso
			DECLARE curGenerarRecursosxDiaxHorario CURSOR FOR
			SELECT Id_Recurso_Horario, Hora_Inicio, Hora_Fin, Frecuencia
			FROM Empresas_Sedes_Sec_Recuros_Horarios
			WHERE
			Activo = 1
			AND Id_Recurso = @pId_Recurso
			AND (	(ISNULL(Lunes, 0) = 1 AND @Dia_De_La_Semana = 'Monday') OR
					(ISNULL(Martes, 0) = 1 AND @Dia_De_La_Semana = 'Tuesday') OR
					(ISNULL(Miercoles, 0) = 1 AND @Dia_De_La_Semana = 'Wednesday') OR
					(ISNULL(Jueves, 0) = 1 AND @Dia_De_La_Semana = 'Thursday') OR
					(ISNULL(Viernes, 0) = 1 AND @Dia_De_La_Semana = 'Friday') OR
					(ISNULL(Sabado, 0) = 1 AND @Dia_De_La_Semana = 'Saturday') OR
					(ISNULL(Domingo, 0) = 1 AND @Dia_De_La_Semana = 'Sunday')
				)
			
			OPEN curGenerarRecursosxDiaxHorario
			FETCH NEXT FROM curGenerarRecursosxDiaxHorario INTO @Id_Recurso_Horario, @Hora_Inicio, @Hora_Fin, @Frecuencia
			WHILE @@FETCH_STATUS = 0
			BEGIN
				IF(@pModoDebug = 1)
				BEGIN
					PRINT 'Id_Recurso_Horario: ' + CONVERT(VARCHAR(10), @Id_Recurso_Horario) + ' Hora_Inicio: ' + CONVERT(VARCHAR(5), @Hora_Inicio, 8) + ' Hora_Fin: ' + CONVERT(VARCHAR(5), @Hora_Fin, 8) + ' Frecuencia: ' + CONVERT(VARCHAR(10), @Frecuencia)
				END
				
				--Hora inicio Ej: Ej. 1900-01-01T10:00:00
				--Hora fin Ej: Ej. 1900-01-01T10:50:00
				
				-- Primer Minuto a generar (Ej. 1900-01-01T10:00:00)				
				SET @cadaMinutoAGenerar = @Hora_Inicio
				
				WHILE (@cadaMinutoAGenerar <= @Hora_Fin)
				BEGIN
					IF(@pModoDebug = 1)
					BEGIN
						PRINT 'Hora: ' + CONVERT(VARCHAR(5), @cadaMinutoAGenerar, 8)
					END
					
					SET @Flag_Id_Recurso_Bloq = ISNULL((SELECT Id_Recurso_Bloq 
														FROM Empresas_Sedes_Sec_Recuros_Bloqueos 
														WHERE 
														Activo = 1
														AND Id_Recurso = @pId_Recurso 
														AND ((ISNULL(Lunes, 0) = 1 AND @Dia_De_La_Semana = 'Monday') OR
															(ISNULL(Martes, 0) = 1 AND @Dia_De_La_Semana = 'Tuesday') OR
															(ISNULL(Miercoles, 0) = 1 AND @Dia_De_La_Semana = 'Wednesday') OR
															(ISNULL(Jueves, 0) = 1 AND @Dia_De_La_Semana = 'Thursday') OR
															(ISNULL(Viernes, 0) = 1 AND @Dia_De_La_Semana = 'Friday') OR
															(ISNULL(Sabado, 0) = 1 AND @Dia_De_La_Semana = 'Saturday') OR
															(ISNULL(Domingo, 0) = 1 AND @Dia_De_La_Semana = 'Sunday')
															)
														AND Hora_Inicio <= @cadaMinutoAGenerar
														AND Hora_Fin >= @cadaMinutoAGenerar)
														, 0)
					
					IF(@Flag_Id_Recurso_Bloq > 0)
					BEGIN
						IF(@pModoDebug = 1)
						BEGIN
							PRINT 'El recurso se encuentra bloqueado para la hora: ' + CONVERT(VARCHAR(5), @cadaMinutoAGenerar, 8) + ' a traves del Id_Recurso_Bloq = ' + CONVERT(VARCHAR(10), @Flag_Id_Recurso_Bloq)
						END
					END
					ELSE
					BEGIN					
						SET @fechaCompletaAGenerar = CONVERT(DATETIME, 
																	CAST(DATEPART(yy, @cadaDiaAGenerar) AS CHAR(4)) + '-' + RIGHT('00' + CAST(DATEPART(mm, @cadaDiaAGenerar) AS VARCHAR), 2) + '-' + RIGHT('00' + CAST(DATEPART(dd, @cadaDiaAGenerar) AS VARCHAR), 2) 
																	+ 'T' + 
																	RIGHT('00' + CAST(DATEPART(HOUR, @cadaMinutoAGenerar) AS VARCHAR), 2) + ':' + RIGHT('00' + CAST(DATEPART(MINUTE, @cadaMinutoAGenerar) AS VARCHAR), 2) + ':' + '00'
															)

						IF(@pModoDebug = 1)
						BEGIN
							PRINT 'Fecha Completa a Generar: ' + CONVERT(VARCHAR(20), @fechaCompletaAGenerar, 120)
						END

						SET @Flag_Ya_Existe_Turno = ISNULL((SELECT 1 FROM CRM_Turnos WHERE Id_Recurso = @pId_Recurso AND Fecha = @fechaCompletaAGenerar), 0)
						
						IF(@pModoDebug = 1)
						BEGIN
							PRINT '@Flag_Ya_Existe_Turno: ' + CONVERT(VARCHAR(10), @Flag_Ya_Existe_Turno)
						END
							
						IF(@Flag_Ya_Existe_Turno = 1)
						BEGIN
							IF(@pModoDebug = 1)
							BEGIN
								PRINT 'Ya existia un turno generado para el Id_Recurso: ' + CONVERT(VARCHAR(10), @pId_Recurso) + ' en la Fecha: ' + CONVERT(VARCHAR(20), @fechaCompletaAGenerar, 120)
							END
						END
						ELSE
						BEGIN					
							IF(@pModoDebug = 1)
							BEGIN
								PRINT 'Genera registro CRM_Turnos con los siguientes datos: Id_Usuario: ' + CONVERT(VARCHAR(10), @pId_Usuario) + '. Id_Recurso: ' + CONVERT(VARCHAR(10), @pId_Recurso) + ' Fecha: ' + CONVERT(VARCHAR(20), @fechaCompletaAGenerar, 120)
							END
							
							--Inserta el registro en CRM_Turnos
							SET @Cantidad_Turnos_Generados = @Cantidad_Turnos_Generados + 1
							INSERT INTO CRM_Turnos
							(Id_Usuario,			Id_Cliente,			Id_Recurso, 
							Fecha,					Descripcion,		Estado,
							Id_Trans)
							VALUES
							(@pId_Usuario,			0,					@pId_Recurso,
							@fechaCompletaAGenerar,	'',					'',
							0)
						END
					END
					
					--Siguiente minuto a generar
					SET @cadaMinutoAGenerar = DATEADD(MINUTE, @Frecuencia, @cadaMinutoAGenerar)
				END

				FETCH NEXT FROM curGenerarRecursosxDiaxHorario INTO @Id_Recurso_Horario, @Hora_Inicio, @Hora_Fin, @Frecuencia
			END
			CLOSE curGenerarRecursosxDiaxHorario
			DEALLOCATE curGenerarRecursosxDiaxHorario
			--FIN Recorro todos los horarios que tiene el recurso
		END--IF(@pId_Recurso <> 0)
		
		--Siguiente Dia a generar
		SET @cadaDiaAGenerar = DATEADD(dd, 1, @cadaDiaAGenerar)
	END--WHILE(@cadaDiaAGenerar <= @pFecha_Hasta)

	/*===================================================================*/	

	IF @pFlagUsarTrans <> 0 COMMIT

	SELECT	 0							AS ErrorNumber 
			,0							AS ErrorSeverity  
			,0							AS ErrorState 
			,0							AS ErrorProcedure  
			,@Cantidad_Turnos_Generados	AS ErrorLine		
			,''							AS ErrorMessage

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Fin Stored Procedure: CPJ_Turnos_Generar'
	END
	
END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo

	IF @pFlagUsarTrans <> 0  ROLLBACK

	RETURN 9999
END CATCH

RETURN 0 

--Ejemplo de uso
--EXEC CPJ_Turnos_Generar '{"FlagUsarTrans":"0", "ModoDebug":"1", "Id_Usuario":"-1", "Id_Sector":"2", "Fecha_Desde":"20200601", "Fecha_Hasta":"20200630"}'